
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for the transportation domain
car_weights = np.random.normal(loc=1.5, scale=0.5, size=1000)  # mean=1.5 tons, sd=0.5 tons
truck_weights = np.random.normal(loc=8.0, scale=2.0, size=1000)  # mean=8 tons, sd=2 tons

# Define the number of bins and bin edges for consistent bin width
bins = np.histogram(np.hstack((car_weights, truck_weights)), bins=15)[1]
labels = ["Car", "Truck"]
xticks = [0, 5, 10, 15]
xlabel = "Weight (tons)"
ylabel = "Count"
title = "Distribution of Vehicle Weights in Transportation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 5))

# Create the histograms without stacking
plt.hist(
    car_weights,
    bins=bins,
    color="#5a9bd4",
    label=labels[0],
    edgecolor="white",
    linewidth=0.6,
    alpha=0.7,
    zorder=2,
)
plt.hist(
    truck_weights,
    bins=bins,
    color="#f28e2b",
    label=labels[1],
    edgecolor="white",
    linewidth=0.6,
    alpha=0.7,
    zorder=3,
)

# Set the background color
plt.gca().set_facecolor("#f0f0f0")

# Set the scale of y-axis to logarithmic
plt.yscale("log")

# Set the x-axis ticks
plt.xticks(xticks)
plt.tick_params(axis="x", length=0)

# Add white grid lines and place them behind the bars (zorder=0)
plt.grid(color="white", linestyle="-", linewidth=1.5, zorder=0)

# Set the y-axis ticks and remove all line markings (spines)
plt.yticks([1, 10, 100, 1000])
plt.tick_params(axis="y", length=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)  # Remove all the spines

# remove small dash on y-axis
plt.tick_params(axis="y", which="minor", length=0)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add legend with title
plt.legend(title="Vehicle Type")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Show the plot
plt.savefig("hist_27.pdf", bbox_inches="tight")
