
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate heart rate data using normal distribution
# Mean heart rate = 75 bpm, Standard deviation = 10 bpm, Sample size = 10000
data = np.random.normal(loc=75, scale=10, size=10000)
data = data[(data >= 60) & (data <= 100)]  # Limit to typical resting heart rate range

# Labels and other text parameters
xlabel = "Heart Rate (beats per minute)"
ylabel = "Number of Individuals"
title = "Distribution of Resting Heart Rates"
legendlabels = ["Filled Histogram", "Step Histogram"]

# Bins List
binslist = [40, 40]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 4))

# Show grid with some transparency
plt.grid(True, linestyle="--", linewidth=0.5, color="#000000", alpha=0.3)

# Create the filled histogram
plt.hist(data, bins=binslist[0], color="#76c7c0", label=legendlabels[0])

# Create the step histogram
plt.hist(
    data,
    bins=binslist[1],
    color="#66a1cc",
    edgecolor="#4477aa",
    histtype="step",
    linewidth=1.5,
    label=legendlabels[1],
)

# Set the title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_33.pdf", bbox_inches="tight")
