
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate synthetic financial data (e.g., stock returns or similar)
mu, sigma = 0.001, 0.02 # mean and standard deviation
data = np.random.lognormal(mean=mu, sigma=sigma, size=10000)
data = data[data < 2]  # Limiting the data to a sensible range for visualization

# Titles and labels
xlabel = "Daily Returns (%)"
ylabel = "Frequency"
title = "Distribution of Daily Stock Returns"
legend_labels = ["Frequency", "Step Histogram"]
binslist = [30, 30]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to the desired dimensions
plt.figure(figsize=(6, 4))

# Show grid with some customization
plt.grid(True, linestyle="--", linewidth=0.5, color="#cccccc", alpha=0.7)

# Create the histogram with filled bars
plt.hist(data, bins=binslist[0], color="#8fd694", label=legend_labels[0])

# Create the histogram with histtype='step' for edge-only bars
plt.hist(
    data,
    bins=binslist[1],
    color="#56a869",
    edgecolor="#379237",
    histtype="step",
    linewidth=1.2,
    label=legend_labels[1],
)

# Set the title and labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add a legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("hist_34.pdf", bbox_inches="tight")
