
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate data for energy consumption in residential and commercial properties
residential_consumption = np.random.exponential(scale=1.2, size=1000)
commercial_consumption = np.random.exponential(scale=3.0, size=1000)

# Labels and other text
labels = ["Residential Consumption", "Commercial Consumption"]
xlabel = "Energy Consumption (kWh)"
ylabel = "Frequency"
title = "Energy Consumption Distribution"
bins = 40

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to a suitable dimension
plt.figure(figsize=(10, 6))

# Plot histograms with stacked bars
plt.hist(
    [residential_consumption, commercial_consumption],
    bins=bins,
    stacked=True,
    label=labels,
    color=["#2ca02c", "#1f77b4"],  # Green for residential, Blue for commercial
    edgecolor='black',  # Add edge color for better visual distinction
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Adjust x-axis range to match the data range
plt.xlim(left=plt.xlim()[0] + 0.1, right=15)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_36.pdf", bbox_inches="tight")
