
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate data for tourism distances
domestic_travel = np.random.exponential(scale=200, size=1000)
international_travel = np.random.exponential(scale=1000, size=1000)
labels = ["Domestic Travel", "International Travel"]
xlabel = "Distance Travelled (km)"
ylabel = "Number of Tourists"
title = "Distribution of Travel Distances"
bins = 50

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to be more visually appealing for presentation
plt.figure(figsize=(10, 6))

# Plot histograms with stacked bars
plt.hist(
    [domestic_travel, international_travel],
    bins=bins,
    stacked=True,
    label=labels,
    color=["#4CAF50", "#2196F3"],  # Green for domestic, blue for international
    edgecolor="black",  # Add edge color for better distinction
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Adjust x-axis range to accommodate the new data and to add space at the beginning
plt.xlim(left=0, right=5000)

# Optional: Add grid for better readability
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_37.pdf", bbox_inches="tight")
