
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(0)
engagement_levels = np.array([0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9])
conversion_rates = np.array([0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.5, 0.45, 0.6])
calibration_error = 0.25
text = f"Calibration Error:\n{calibration_error}"

# Axes Limits and Labels
xlabel_value = "Engagement Level"
ylabel_value = "Conversion Rate"
title = "Customer Engagement vs Conversion Rates"
xlim_values = [0, 1]
ylim_values = [0, 1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 6))

# Plot histogram using plt.hist and specify bins
plt.hist(engagement_levels, bins=9, weights=conversion_rates, color="#ffcccb", edgecolor="#ff6666")

# Add diagonal dashed line
plt.plot([0, 1], [0, 1], linestyle="--", linewidth=2, color="#6b8e23")

# Add text for calibration error
plt.text(0.05, 0.9, text, color="#ff6347", fontsize=14)

# Set labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=16)

# Adjust x and y axis limits to match the reference picture
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_39.pdf", bbox_inches="tight")
