
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data (replace with actual data)
image_overlap = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9]
number_of_queries = [800, 2200, 3500, 4200, 5400, 5000, 4800, 3000, 1200]

# Axes Limits and Labels
xlabel_value = "Percentage of Energy Source Overlap"
ylabel_value = "Frequency of Queries"
xlim_values = [0, 1.0]
ylim_values = [0, 6000]


# Chart title and additional text
chart_title = "Query Frequency Based on Energy Source Overlap"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a histogram
# Color scheme
color_hist = "#4CAF50"
plt.figure(figsize=(8, 6))  # Adjusted for better visibility
plt.hist(image_overlap, bins=9, weights=number_of_queries, color=color_hist, edgecolor='black', alpha=0.7)

# Set the labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(chart_title, fontsize=14, fontweight='bold')

# Remove ticks on both axes
plt.tick_params(axis="both", which="both", length=0)

# Set the range for the axes
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Grid for better readability
plt.grid(axis='y', linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("hist_44.pdf", bbox_inches="tight")
