
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new scientific data
data1 = np.random.normal(1.5, 0.3, 10000)  # Experiment A
data2 = np.random.normal(2.0, 0.4, 10000)  # Experiment B
binslist = [100, 100]
titles = ["Experiment A", "Experiment B"]
rangelist = [(0, 3), (0, 3)]

# Text label parameters
xlabel = "Measurement Value"
ylabel = "Frequency"
supertitle = "Scientific Experiments Data Distribution"
legendlabels = ["Experiment A Data", "Experiment B Data"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(10, 7), gridspec_kw={"hspace": 0.3})

# First histogram (Experiment A)
axs[0].hist(data1, bins=binslist[0], range=rangelist[0], color="green", edgecolor='black', alpha=0.7)
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)

# Second histogram (Experiment B)
axs[1].hist(data2, bins=binslist[1], range=rangelist[1], color="orange", edgecolor='black', alpha=0.7)
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)

# Add a super title
fig.suptitle(supertitle)

# Add legends
axs[0].legend([legendlabels[0]])
axs[1].legend([legendlabels[1]])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0, 1, 0.95])  # Adjust rect to accommodate the supertitle
plt.savefig("hist_45.pdf", bbox_inches="tight")
