
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample environmental science data
temperature_changes = np.random.normal(15, 3, 10000)  # Daily temperature changes (Celsius)
precipitation_amounts = np.random.gamma(2, 0.5, 10000)  # Daily precipitation amounts (mm)
binslist = [100, 100]
titles = ["Daily Temperature Changes", "Daily Precipitation Amounts"]
rangelist = [(5, 25), (0, 8)]
xlabel = "Value"
ylabel = ["Frequency", "Frequency"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(10, 7), gridspec_kw={"hspace": 0.3})

# First histogram: Daily Temperature Changes
axs[0].hist(temperature_changes, bins=binslist[0], range=rangelist[0], color="#4caf50")
axs[0].set_title(titles[0], fontsize=14, fontweight='bold')
axs[0].set_xlabel(xlabel, fontsize=12)
axs[0].set_ylabel(ylabel[0], fontsize=12)
axs[0].grid(True)

# Second histogram: Daily Precipitation Amounts
axs[1].hist(precipitation_amounts, bins=binslist[1], range=rangelist[1], color="#2196f3")
axs[1].set_title(titles[1], fontsize=14, fontweight='bold')
axs[1].set_xlabel(xlabel, fontsize=12)
axs[1].set_ylabel(ylabel[1], fontsize=12)
axs[1].grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("hist_46.pdf", bbox_inches="tight")
