
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data (replace with actual data)
intra_class_left = np.random.normal(0.1, 0.15, 1000)
inter_class_left = np.random.normal(0.3, 0.15, 1000)
intra_class_right = np.random.normal(0.2, 0.1, 1000)
inter_class_right = np.random.normal(0.4, 0.15, 1000)
xlabel = "Philosophical Opinion Frequency"
ylabel = "Occurrence"
binslist = [25, 25, 25, 25]
labels = ["Inter-School Opinions", "Intra-School Opinions"]
title_left = "Classical vs. Modern Philosophy"
title_right = "Analytic vs. Continental Philosophy"
suptitle = "Philosophical Opinions Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(12, 5))

# Left subplot
ax_left = plt.subplot(1, 2, 1)
plt.hist(
    inter_class_left,
    bins=binslist[0],
    alpha=0.5,
    label=labels[0],
    color="#B0C4DE",
    zorder=2,
    edgecolor='#5B8C5A'
)
plt.hist(
    intra_class_left,
    bins=binslist[1],
    alpha=0.5,
    label=labels[1],
    color="#8B0000",
    zorder=3,
    edgecolor='#5B8C5A'
)
leg = plt.legend(frameon=False)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title_left, fontsize=12)
plt.tick_params(axis="both", which="both", length=0)
plt.gca().set_facecolor("#F5F5DC")
plt.grid(True, color="white", zorder=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# Right subplot
ax_right = plt.subplot(1, 2, 2)
plt.hist(
    inter_class_right,
    bins=binslist[2],
    alpha=0.5,
    label=labels[0],
    color="#B0C4DE",
    zorder=2,
    edgecolor='#5B8C5A'
)
plt.hist(
    intra_class_right,
    bins=binslist[3],
    alpha=0.5,
    label=labels[1],
    color="#8B0000",
    zorder=3,
    edgecolor='#5B8C5A'
)
leg = plt.legend(frameon=False)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title_right, fontsize=12)
plt.tick_params(axis="both", which="both", length=0)
plt.gca().set_facecolor("#F5F5DC")
plt.grid(True, color="white", zorder=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# Set axis spine colors to black
for ax in [ax_left, ax_right]:
    for spine in ax.spines.values():
        spine.set_edgecolor("black")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.suptitle(suptitle, fontsize=14)
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

# Display the figure
plt.savefig("hist_50.pdf", bbox_inches="tight")
