
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data relevant to education domain (test scores for different subjects)
math_scores = np.random.normal(75, 10, 1000)  # Mean = 75, SD = 10
science_scores = np.random.normal(72, 12, 1000)  # Mean = 72, SD = 12
english_scores = np.random.normal(78, 8, 1000)  # Mean = 78, SD = 8
history_scores = np.random.normal(70, 15, 1000)  # Mean = 70, SD = 15

# Define the titles for each subplot
titles = [
    "Math Scores",
    "Science Scores",
    "English Scores",
    "History Scores",
    "Math Scores (Variation 2)",
    "Science Scores (Variation 2)",
    "English Scores (Variation 2)",
    "History Scores (Variation 2)",
]

xlabel = "Score"
ylabel = "Density"
bins = 30
xvline = 75  # Using 75 as a common benchmark score

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(14, 10))  # Adjusted to wider dimensions
# Define the colors for each subplot
colors = [
    "#1f77b4", "#ff7f0e", "#2ca02c", "#d62728",
    "#9467bd", "#8c564b", "#e377c2", "#7f7f7f",
]
# Create subplots
for i in range(8):
    plt.subplot(4, 2, i + 1)
    if i % 2 == 0:
        data = math_scores if i == 0 else (english_scores if i == 2 else science_scores if i == 4 else history_scores)
    else:
        data = math_scores if i == 1 else (english_scores if i == 3 else science_scores if i == 5 else history_scores)
    plt.hist(data, bins=bins, density=True, alpha=0.6, color=colors[i], range=(30, 120))
    plt.title(titles[i])
    plt.xlabel(xlabel)
    plt.ylabel(ylabel)
    plt.axvline(x=xvline, color='k', linestyle='--', linewidth=1)  # Dashed line for benchmark score

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.tight_layout(pad=0.4, w_pad=0.5, h_pad=1.0)  # Adjusted padding for tighter layout
plt.savefig("hist_55.pdf", bbox_inches="tight")
