
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate bimodal data for stress levels of students
students_peak1 = np.random.normal(loc=2, scale=0.5, size=200)
students_peak2 = np.random.normal(loc=7, scale=0.5, size=200)
students_stress = np.concatenate([students_peak1, students_peak2])

# Generate bimodal data for stress levels of professionals
professionals_peak1 = np.random.normal(loc=3, scale=0.7, size=500)
professionals_peak2 = np.random.normal(loc=6, scale=0.7, size=500)
professionals_stress = np.concatenate([professionals_peak1, professionals_peak2])

labels = ["Students", "Professionals"]
xticks = np.arange(0, 11, 1)
yticks = [1, 10, 100]
xlabel = "Stress Level (Scale 0-10)"
ylabel = "Frequency"
title = "Stress Levels in Different Groups"
legendtitle = "Groups"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(6, 6))

# Define the number of bins and bin edges for consistent bin width
bins = np.histogram(np.hstack((students_stress, professionals_stress)), bins=15)[1]

# Create the histograms without stacking
# New colors using hex codes
plt.hist(
    students_stress,
    bins=bins,
    color="#4daf4a",
    label=labels[0],
    edgecolor="white",
    linewidth=0.6,
    alpha=0.6,
    zorder=2,
)
plt.hist(
    professionals_stress,
    bins=bins,
    color="#377eb8",
    label=labels[1],
    edgecolor="white",
    linewidth=0.6,
    alpha=0.6,
    zorder=3,
)

# Set the background color
plt.gca().set_facecolor("#f5f5f5")

# Set the scale of y-axis to logarithmic
plt.yscale("log")

# Set the x-axis ticks
plt.xticks(xticks)  # Adjusted to show more ticks
plt.tick_params(axis="x", length=0)

# Add white grid lines and place them behind the bars (zorder=0)
plt.grid(color="white", linestyle="-", linewidth=1.5, zorder=0)

# Set the y-axis ticks and remove all line markings (spines)
plt.yticks(yticks)  # Adjusted to show additional y-axis tick
plt.tick_params(axis="y", length=0)

# Remove spine lines
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# Remove small dash on y-axis
plt.tick_params(axis="y", which="minor", length=0)

# Set labels and title
plt.xlabel(xlabel)  # Adjusted label
plt.ylabel(ylabel)  # Adjusted label
plt.title(title)  # Adjusted title

# Move legend to the bottom center of the plot
plt.legend(
    title=legendtitle, loc="upper center", bbox_to_anchor=(0.5, -0.15), ncol=2
)  # Adjust legend position and make it span 2 columns

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to make room for the legend
plt.tight_layout()  # We might need to adjust this to account for the new legend position

plt.savefig("hist_57.pdf", bbox_inches="tight")
