
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for communication metrics
messages_sent = np.random.poisson(5, 1000)  # Skewed distribution for messages sent
time_spent = np.random.normal(30, 10, 1000)  # Normal distribution for time spent

# Define bins for both histograms with a little space between bars
bin_width = 0.6
bins = np.histogram(np.hstack((messages_sent, time_spent)), bins=30)[1]
labels = ["Messages Sent", "Time Spent in Communication"]
xlabel = "Metric Value"
ylabel = "Frequency"
title = "Communication Metrics Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusted size

# Plot histograms using plt.hist() with appropriate alignment and new colors
ax.hist(messages_sent, bins=bins, alpha=0.7, label=labels[0], color="#1f77b4", edgecolor="black")
ax.hist(time_spent, bins=bins, alpha=0.7, label=labels[1], color="#ff7f0e", edgecolor="black")

# Set labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Add title
ax.set_title(title)

# Add grid
ax.grid(color="#d3d3d3", linestyle="-", linewidth=0.5, zorder=0)

# Add legend at a new location
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_61.pdf", bbox_inches="tight")
