
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate normally distributed data for religious service attendance
data = np.random.normal(loc=150, scale=50, size=10000)

# Axes Limits and Labels
title = "Histogram of Religious Service Attendance"
xlabel_value = "Number of Attendees"
ylabel_value = "Frequency"
# Highlight the median of the data
median = np.median(data)
annotation_text = f"Median: {median:.2f}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 7))

# Enable the grid
plt.grid(True, linestyle="--", linewidth=0.5, alpha=0.7, color="grey")

# Histogram of the data
n, bins, patches = plt.hist(data, bins=30, color="#7DCEA0", edgecolor="#196F3D", alpha=0.75)

plt.axvline(median, color="#884EA0", linestyle="dashed", linewidth=2)

# Adjust the median text position to not overlap the bars when possible
median_text_position = max(n) * 0.9
for bin_edge, count in zip(bins, n):
    if bin_edge > median and count < median_text_position:
        # Place the text above the median position
        median_text_position = count
        break
plt.text(median + 5, median_text_position, annotation_text, color="#884EA0", fontsize=12)

# Title and labels relevant to the new dataset
plt.title(title, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout
plt.tight_layout()

plt.savefig("hist_65.pdf", bbox_inches="tight")
