
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for tourism
beaches = np.random.normal(loc=1000, scale=200, size=1000)
mountains = np.random.normal(loc=700, scale=150, size=1000)

# Labels and Plot Types
hist_label = ["Beaches", "Mountains"]

# Axes Limits and Labels
xlabel_value = "Number of Tourists"
ylabel_value = "Frequency"
title = "Tourism Spot Popularity Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(8, 6))

# Plot histograms with stacked bars, modified colors, and alpha for transparency
plt.hist(
    [beaches, mountains],
    bins=30,
    stacked=True,
    label=hist_label,
    color=["#1E90FF", "#228B22"],
    alpha=0.7,
)

# Add labels, title, and modify the style of the labels
plt.xlabel(xlabel_value, color="#333333")
plt.ylabel(ylabel_value, color="#333333")
plt.title(title)

# Modify the legend style and position to lower right
plt.legend(frameon=True, loc="upper right")

# Adjust x-axis range and add some space at the beginning of the x-axis
plt.xlim(left=plt.xlim()[0], right=1800) 

# Add grid with lighter color and set behind the histograms
plt.grid(color="grey", linestyle="--", linewidth=0.5, alpha=0.7)
plt.gca().set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_67.pdf", bbox_inches="tight")
