
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Simulated ticket sales data (in thousands) for different entertainment types
concert_data_weekends = np.random.normal(15, 5, 10000)
concert_data_weekdays = np.random.normal(7, 3, 10000)
movie_data_weekends = np.random.normal(25, 10, 10000)
movie_data_weekdays = np.random.normal(10, 5, 10000)

suptitle = "Ticket Sales Distribution for Entertainment"
binslist = [50, 50]
titles = ["Concert Ticket Sales", "Movie Ticket Sales"]
labels = ["Weekends", "Weekdays"]
ranges = (0, 35)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(12, 8), gridspec_kw={"hspace": 0.5})

# Overall title (suptitle)
fig.suptitle(suptitle)

# First histogram (Concert Ticket Sales)
n, bins, patches = axs[0].hist(
    concert_data_weekends, bins=binslist[0], range=ranges, alpha=0.75, label=labels[0], color="#6a0dad"
)
axs[0].hist(concert_data_weekdays, bins=bins, alpha=0.75, label=labels[1], color="#ff69b4")
axs[0].set_title(titles[0])
axs[0].grid(True)  # Adding grid
axs[0].legend()  # Adding legend

# Second histogram (Movie Ticket Sales)
axs[1].hist(
    movie_data_weekends,
    bins=binslist[1],
    range=(0, 50),
    alpha=0.75,
    label=labels[0],
    color="#1e90ff",
)
axs[1].hist(movie_data_weekdays, bins=bins, alpha=0.75, label=labels[1], color="#ff4500")
axs[1].set_title(titles[1])
axs[1].grid(True)  # Adding grid
axs[1].legend()  # Adding legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(
    rect=[0, 0.03, 1, 0.95]
)  # Adjust the layout to accommodate the overall title

plt.savefig("hist_75.pdf", bbox_inches="tight")
