
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for energy consumption patterns of two devices
data1 = np.random.normal(50, 5, 10000)  # Device A - more consistent consumption
data2 = np.random.normal(70, 10, 10000) # Device B - more varied consumption
data3 = np.random.normal(55, 7, 10000)  # Another data for Device A with slight variation
data4 = np.random.normal(75, 12, 10000) # Another data for Device B with higher variance

# Chart labels and titles
suptitle = "Energy Consumption Data Distribution"
binslist = [100, 100]
titles = ["Device A - Energy Consumption", "Device B - Energy Consumption"]
labels = ["Low Usage", "High Usage"]
ranges = (30, 90)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified figure size
fig, axs = plt.subplots(2, 1, figsize=(10, 7), gridspec_kw={"hspace": 0.5})

# Overall title (suptitle)
fig.suptitle(suptitle)

# First histogram (Device A)
n, bins, patches = axs[0].hist(
    data1, bins=binslist[0], range=ranges, alpha=0.7, label=labels[0], color="#33a02c"
)
axs[0].hist(data3, bins=bins, alpha=0.7, label=labels[1], color="#1f78b4")
axs[0].set_title(titles[0])
axs[0].set_xlabel("Energy Consumption (kWh)")
axs[0].set_ylabel("Frequency")
axs[0].grid(True)  # Adding grid
axs[0].legend()  # Adding legend

# Second histogram (Device B)
axs[1].hist(
    data2,
    bins=binslist[1],
    range=ranges,
    alpha=0.7,
    label=labels[0],
    color="#fb9a99",
)
axs[1].hist(data4, bins=bins, alpha=0.7, label=labels[1], color="#e31a1c")
axs[1].set_title(titles[1])
axs[1].set_xlabel("Energy Consumption (kWh)")
axs[1].set_ylabel("Frequency")
axs[1].grid(True)  # Adding grid
axs[1].legend()  # Adding legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(
    rect=[0, 0.03, 1, 0.95]
)  # Adjust the layout to accommodate the overall title

plt.savefig("hist_77.pdf", bbox_inches="tight")
