
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated Exercise Data: Average exercise time in hours per week
data1_walking = np.concatenate(
    [np.random.normal(4, 0.5, 700), np.random.normal(2, 0.3, 300)]
)
data2_walking = np.concatenate(
    [np.random.normal(3, 0.4, 500), np.random.normal(1.5, 0.2, 500)]
)

data1_running = np.concatenate(
    [np.random.normal(2, 0.2, 600), np.random.normal(1, 0.3, 400)]
)
data2_running = np.concatenate(
    [np.random.normal(1.5, 0.5, 700), np.random.normal(0.8, 0.25, 300)]
)

data1_cycling = np.concatenate(
    [np.random.normal(3.5, 0.6, 500), np.random.normal(2, 0.3, 500)]
)
data2_cycling = np.concatenate(
    [np.random.normal(2.5, 0.5, 700), np.random.normal(1.5, 0.25, 300)]
)

data1_swimming = np.concatenate(
    [np.random.normal(2.8, 0.3, 400), np.random.normal(1, 0.35, 600)]
)
data2_swimming = np.concatenate(
    [np.random.normal(2, 0.4, 500), np.random.normal(0.5, 0.2, 500)]
)

binslist = [30, 30]
labels = ["Regular Exercisers", "Occasional Exercisers"]
xlabel = "Average Exercise Time (hours per week)"
ylabel = "Density"
titles = [
    "(a) Walking",
    "(b) Running",
    "(c) Cycling",
    "(d) Swimming",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Plot histograms for each subplot
datasets = [
    (data1_walking, data2_walking),
    (data1_running, data2_running),
    (data1_cycling, data2_cycling),
    (data1_swimming, data2_swimming),
]
colors = [("limegreen", "dodgerblue"), ("forestgreen", "mediumblue"),
          ("seagreen", "royalblue"), ("mediumseagreen", "steelblue")]

for (data1, data2), ax, (color1, color2) in zip(datasets, axs.flatten(), colors):
    ax.hist(
        data1,
        bins=binslist[0],
        density=True,
        alpha=0.6,
        color=color1,
        label=labels[0],
        edgecolor="black",
        linewidth=0.5,
    )
    ax.hist(
        data2,
        bins=binslist[1],
        density=True,
        alpha=0.6,
        color=color2,
        label=labels[1],
        edgecolor="black",
        linewidth=0.5,
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True)
    ax.legend()

# Set titles for each subplot
axs[0, 0].set_title(titles[0])
axs[0, 1].set_title(titles[1])
axs[1, 0].set_title(titles[2])
axs[1, 1].set_title(titles[3])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("hist_78.pdf", bbox_inches="tight")
