
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate random data for temperatures in two cities over Winter and Summer
# Temperature is normally distributed with different means and standard deviations
data_winter_city1 = np.random.normal(-5, 5, 1000)  # City1, Winter
data_summer_city1 = np.random.normal(25, 5, 1000)  # City1, Summer

data_winter_city2 = np.random.normal(-3, 4, 1000)  # City2, Winter
data_summer_city2 = np.random.normal(30, 5, 1000)  # City2, Summer

binslist = [30, 30]
labels = ["City 1", "City 2"]
xlabel = "Temperature (°C)"
ylabel = "Density"
titles = [
    "(a) City 1 Winter vs Summer",
    "(b) City 2 Winter vs Summer",
]
suptitle="Temperature Distributions in Two Cities Across Seasons"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(1, 2, figsize=(12, 6))

# Plot histograms for each subplot
datasets = [
    (data_winter_city1, data_summer_city1),
    (data_winter_city2, data_summer_city2),
]
colors = [("skyblue", "salmon"), ("cornflowerblue", "lightcoral")]

for (data_winter, data_summer), ax, (color_winter, color_summer) in zip(datasets, axs.flatten(), colors):
    ax.hist(
        data_winter,
        bins=binslist[0],
        density=True,
        alpha=0.6,
        color=color_winter,
        label=f"Winter - {labels[0]}",
        edgecolor="black",
        linewidth=0.5,
    )
    ax.hist(
        data_summer,
        bins=binslist[1],
        density=True,
        alpha=0.6,
        color=color_summer,
        label=f"Summer - {labels[0]}",
        edgecolor="black",
        linewidth=0.5,
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True, linestyle='--', linewidth=0.7, alpha=0.7)
    ax.legend()

# Set titles for each subplot
axs[0].set_title(titles[0])
axs[1].set_title(titles[1])

# Add a supertitle for the whole figure
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("hist_79.pdf", bbox_inches="tight")
