
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"]
education = [5, 5.5, 6, 6.5, 7, 7.5, 8, 8.5]
healthcare = [4, 4.3, 4.6, 4.9, 5.2, 5.5, 5.8, 6.1]
technology = [3, 3.5, 4, 4.5, 5, 5.5, 6, 6.5]

# Positions for the bars on the x-axis
ind = np.arange(len(years))

# Labels and Legend
xlabel = "Year"
ylabel = "Trend Score"
education_label = "Education"
healthcare_label = "Healthcare"
technology_label = "Technology"

# Limits
xlim = (years[0], years[-1])
ylim = (0, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjust the size to match the original image's dimensions
ax.plot(years, education, label=education_label, color="#2a9d8f", linestyle='-', marker='o')
ax.plot(years, healthcare, label=healthcare_label, color="#e76f51", linestyle='--', marker='s')
ax.plot(years, technology, label=technology_label, color="#264653", linestyle='-.', marker='^')

# Setting the x-axis and y-axis limits
ax.set_ylim(*ylim)  # Set y-axis to go from 0 to 10
ax.set_xlim(*xlim)  # Set x-axis limits to cover the range of years without extra space

# Labels and Title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)

# Legend
ax.legend(
    loc="upper center", fontsize=14, frameon=False, ncol=3, bbox_to_anchor=(0.5, 1.15)
)

# Grid
ax.grid(True, ls="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_100.pdf", bbox_inches="tight")
