
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Simulated quarterly sales data for four product categories
quarters = [1, 2, 3, 4, 5]
product_A = [200, 220, 240, 260, 280]
product_B = [180, 210, 230, 250, 270]
product_C = [160, 190, 220, 240, 260]
product_D = [150, 180, 200, 220, 240]
average_sales_line_y = [200, 200]
average_sales_line_x = [0, 6]

# Axes Limits and Labels
xlabel_value = "Quarter"
xlim_values = [0, 6]

ylabel_value = "Sales (in thousands)"
ylim_values = [140, 290]
yticks_values = [150, 180, 210, 240, 270]

# Labels
label_A="Product A"
label_B="Product B"
label_C = "Product C"
label_D="Product D"
label_avg="Average Sales"

# Titles
title_1 = "Quarterly Sales Performance"
title_2 = "Products"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 6))  # Adjust figure size for better readability
plt.plot(quarters, product_A, label=label_A, color="#1f77b4", marker="o", linestyle="-", linewidth=2)
plt.plot(quarters, product_B, label=label_B, color="#ff7f0e", marker="s", linestyle="--", linewidth=2)
plt.plot(quarters, product_C, label=label_C, color="#2ca02c", marker="^", linestyle="-.", linewidth=2)
plt.plot(quarters, product_D, label=label_D, color="#9467bd", marker="d", linestyle=":", linewidth=2)
plt.plot(average_sales_line_x, average_sales_line_y, label=label_avg, color="black", linestyle="--", linewidth=1)

# Add title and labels
plt.title(title_1)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(quarters)
plt.xlim(xlim_values)
plt.yticks(yticks_values)
plt.ylim(ylim_values)
# Add legend with additional entry
plt.legend(title=title_2, loc="upper left")

# Adding a grid with slight modifications
plt.grid(color="grey", linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_101.pdf", bbox_inches="tight")
