
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New data for social media platforms
time_periods = [2010, 2012, 2014, 2016, 2018]
facebook_users = [500, 800, 1200, 1500, 1800]
twitter_users = [200, 400, 600, 800, 900]
instagram_users = [100, 300, 800, 1200, 1600]
snapchat_users = [50, 300, 500, 800, 1000]
threshold = [0, 2000]
threshold_time = [2008, 2020]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [2008, 2020]

ylabel_value = "Active Users (in millions)"
ylim_values = [0, 2000]
yticks_values = [0, 500, 1000, 1500, 2000]

# Labels
label_fb = "Facebook"
label_tw = "Twitter"
label_ig = "Instagram"
label_sc = "Snapchat"
label_threshold = "Growth Threshold"

# Titles
title_1 = "Growth of Active Users on Social Media Platforms"
title_2 = "Platforms"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 6))  # Adjust figure size
# Plot with different line styles and marker shapes
plt.plot(time_periods, facebook_users, label=label_fb, color="#3b5998", marker="o", linewidth=2)
plt.plot(time_periods, twitter_users, label=label_tw, color="#1da1f2", marker="s", linestyle="--", linewidth=2)
plt.plot(time_periods, instagram_users, label=label_ig, color="#e4405f", marker="^", linestyle=":", linewidth=2)
plt.plot(time_periods, snapchat_users, label=label_sc, color="#fffc00", marker="d", linestyle="-.", linewidth=2)
# Threshold line
plt.plot(threshold_time, threshold, label=label_threshold, color="black", linestyle="--")

# Add title and labels
plt.title(title_1)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(time_periods)
plt.xlim(xlim_values)
plt.yticks(yticks_values)
plt.ylim(ylim_values)
# Add legend with additional entry
plt.legend(title=title_2, loc="upper left")

# Adding the white grid manually
plt.grid(color="#e0e0e0", linestyle="-", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_103.pdf", bbox_inches="tight")
