
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
regions = ["Region A", "Region B", "Region C", "Region D"]
followers_religion1 = [30, 45, 50, 55]
followers_religion2 = [40, 35, 30, 25]
followers_religion3 = [30, 20, 20, 20]

# Extracted variables
line_label_religion1 = "Religion 1"
line_label_religion2 = "Religion 2"
line_label_religion3 = "Religion 3"
xlim_values = (0.25, 1)
ylim_values = (0, 60)
xlabel_value = "Region"
ylabel_value = "Percentage of Followers"
xticks_values = np.arange(len(regions))

# Label texts
chart_title = "Distribution of Religious Followers by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xtickslabel_fontsize = 14
ytickslabel_fontsize = 14

# Plotting the lines with specific styles
plt.figure(figsize=(10, 6))
plt.plot(
    xticks_values,
    followers_religion1,
    marker="o",
    markersize=8,
    linewidth=2,
    linestyle="-",
    color="#1f77b4",
    label=line_label_religion1
)
plt.plot(
    xticks_values,
    followers_religion2,
    marker="s",
    markersize=8,
    linewidth=2,
    linestyle="--",
    color="#ff7f0e",
    label=line_label_religion2
)
plt.plot(
    xticks_values,
    followers_religion3,
    marker="+",
    markersize=12,
    linewidth=2,
    linestyle=":",
    color="#2ca02c",
    label=line_label_religion3
)

# Setting the x-axis and y-axis limits
plt.ylim(ylim_values)
plt.yticks(fontsize=ytickslabel_fontsize)
plt.xlim((0, len(regions)-1))
plt.xticks(xticks_values, regions, fontsize=xtickslabel_fontsize)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=18)
plt.ylabel(ylabel_value, fontsize=18)
plt.title(chart_title, fontsize=20)

# Adding legend with increased font size
plt.legend(
    fontsize="large",
    loc="upper center",
    ncol=3,
    frameon=False,
    bbox_to_anchor=(0.5, 1.15),
)

# Adding grid
plt.grid(True, alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_105.pdf", bbox_inches="tight")
