
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
sample_ratio = [0.25, 0.50, 0.75, 1.00]
std_temp_500 = [0.12, 0.09, 0.05, 0.04]
std_temp_1000 = [0.10, 0.07, 0.04, 0.03]
std_temp_2000 = [0.08, 0.05, 0.03, 0.02]

# Extracted variables
line_label_500 = "SAMPLES=500"
line_label_1000 = "SAMPLES=1000"
line_label_2000 = "SAMPLES=2000"
xlim_values = (0.25, 1)
ylim_values = (0.00, 0.13)
xlabel_value = "Sample Ratio"
ylabel_value = "Std Dev of Temperature Anomalies"
title_value = "Standard Deviation of Temperature Anomalies"
xticks_values = sample_ratio
yticks_values = None  # Not explicitly set in the code

xtickslabel_fontsize = 14
ytickslabel_fontsize = 14

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with increased marker size and line width
plt.figure(figsize=(8, 6))

plt.plot(
    sample_ratio,
    std_temp_500,
    marker="o",
    markersize=10,
    linewidth=2,
    linestyle="--",
    color="#1f77b4",  # Blue
    label=line_label_500,
    clip_on=False,
    zorder=10,
)
plt.plot(
    sample_ratio,
    std_temp_1000,
    marker="^",
    markerfacecolor="white",
    markersize=10,
    linewidth=2,
    linestyle="-.",
    markeredgecolor="#ff7f0e",  # Orange
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    label=line_label_1000,
)
plt.plot(
    sample_ratio,
    std_temp_2000,
    marker="s",
    markerfacecolor="white",
    markersize=10,
    linewidth=2,
    linestyle=":",
    markeredgecolor="#2ca02c",  # Green
    color="#2ca02c",
    clip_on=False,
    zorder=10,
    label=line_label_2000,
)

# Setting the x-axis and y-axis limits
plt.ylim(*ylim_values)
plt.yticks(fontsize=ytickslabel_fontsize)
plt.xlim(*xlim_values)
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=18)
plt.ylabel(ylabel_value, fontsize=18)
plt.title(title_value, fontsize=20)

# Adding legend with increased font size
plt.legend(
    fontsize="large",
    loc="upper center",
    ncol=3,
    frameon=False,
    bbox_to_anchor=(0.5, 1.15),
)

# Adding grid
plt.grid(True, alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_106.pdf", bbox_inches="tight")

