
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Variable extraction
line_label_site_a = "Site A"
line_label_site_b = "Site B"
xlim_values = (0, 200)
ylim_values_co2 = (350, 450)
ylim_values_temp = (14, 24)
ylim_values_humidity = (40, 80)
ylim_values_aqi = (50, 150)
xlabel_value = "Days"
ylabel_value_co2 = "CO2 levels (ppm)"
ylabel_value_temp = "Temperature (°C)"
ylabel_value_humidity = "Humidity (%)"
ylabel_value_aqi = "Air Quality Index"
yticks_values_co2 = [350, 375, 400, 425, 450]
yticks_values_temp = [14, 16, 18, 20, 22, 24]
yticks_values_humidity = [40, 50, 60, 70, 80]
yticks_values_aqi = [50, 75, 100, 125, 150]

# Generate new data for environmental metrics
# CO2 levels
iterations = np.linspace(0, 200, 21)
co2_site_a = np.random.normal(loc=400, scale=10, size=len(iterations))
co2_site_b = np.random.normal(loc=375, scale=15, size=len(iterations))

# Temperature
temp_site_a = np.random.normal(loc=20, scale=2, size=len(iterations))
temp_site_b = np.random.normal(loc=18, scale=1.5, size=len(iterations))

# Humidity
humidity_site_a = np.random.normal(loc=60, scale=5, size=len(iterations))
humidity_site_b = np.random.normal(loc=55, scale=7, size=len(iterations))

# Air Quality Index
aqi_site_a = np.random.normal(loc=100, scale=20, size=len(iterations))
aqi_site_b = np.random.normal(loc=80, scale=15, size=len(iterations))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.2)
legend_frameon = False
legend_ncol = 2
grid_value = True

# Create subplots
fig, axs = plt.subplots(4, 1, figsize=(8, 10))

# Plotting CO2 levels
axs[0].plot(iterations, co2_site_a, label=line_label_site_a, color="darkgreen", linestyle="--", marker="o")
axs[0].plot(iterations, co2_site_b, label=line_label_site_b, color="limegreen", linestyle=":", marker="s")
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_co2)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_co2)
axs[0].set_yticks(yticks_values_co2)
axs[0].tick_params(axis="both", which="both", color="gray")

# Plotting Temperature
axs[1].plot(iterations, temp_site_a, label=line_label_site_a, color="red", linestyle="--", marker="x")
axs[1].plot(iterations, temp_site_b, label=line_label_site_b, color="orangered", linestyle="-.", marker="d")
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_temp)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_temp)
axs[1].set_yticks(yticks_values_temp)
axs[1].tick_params(axis="both", which="both", color="gray")

# Plotting Humidity
axs[2].plot(iterations, humidity_site_a, label=line_label_site_a, color="blue", linestyle="-", marker="<")
axs[2].plot(iterations, humidity_site_b, label=line_label_site_b, color="dodgerblue", linestyle="--", marker=">")
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_humidity)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_humidity)
axs[2].set_yticks(yticks_values_humidity)
axs[2].tick_params(axis="both", which="both", color="gray")

# Plotting Air Quality Index
axs[3].plot(iterations, aqi_site_a, label=line_label_site_a, color="goldenrod", linestyle="-.", marker="h")
axs[3].plot(iterations, aqi_site_b, label=line_label_site_b, color="gold", linestyle="--", marker="*")
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_aqi)
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_aqi)
axs[3].set_yticks(yticks_values_aqi)
axs[3].tick_params(axis="both", which="both", color="gray")

# Add legends and gridlines to each subplot
for ax in axs.flat:
    ax.legend(
        loc=legend_location,
        bbox_to_anchor=legend_bbox_to_anchor,
        frameon=legend_frameon,
        ncol=legend_ncol,
    )
    ax.grid(grid_value)  # Enable the grid

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("line_107.pdf", bbox_inches="tight")
