
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
import numpy as np

np.random.seed(42)
quarters = [1, 2, 3, 4]
profits = np.array([0.3, 0.5, 0.7, 0.9])
expenses = np.array([0.4, 0.3, 0.5, 0.4])

# Axes Limits and Labels
xlabel_value = "Quarter"
xlim_values = [0.5, 4.5]

ylabel_value = "Normalized Value"
ylim_values = [0, 1.0]
yticks_values = [0, 0.25, 0.5, 0.75, 1.0]

axvspan1_l, axvspan1_r = 2.5, 3.5

# Labels
label_1 = "Quarterly Profits"
label_2 = "Quarterly Expenses"

# Annotations
annotation_1 = "Introduce new policy"
annotation_2 = "Operational changes"
title_text = "Company's Quarterly Performance"
suptitle_text = "Economic Analysis in 2022"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(quarters, profits, "o-", color="navy", label=label_1, linewidth=2)
ax.plot(quarters, expenses, "s--", color="darkorange", label=label_2, linewidth=2)

# Highlight specific regions
ax.axvspan(axvspan1_l, axvspan1_r, color="lightgrey", alpha=0.5, label="Fluctuation Period")

# Annotations
ax.annotate(
    annotation_1,
    xy=(2, 0.5),
    xytext=(2.2, 0.7),
    arrowprops=dict(facecolor="green", shrink=0.05),
)
ax.annotate(
    annotation_2,
    xy=(3, 0.5),
    xytext=(3.2, 0.6),
    arrowprops=dict(facecolor="red", shrink=0.05),
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_xlim(xlim_values)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xticks(quarters)
ax.set_ylabel(ylabel_value)
ax.set_title(title_text)
fig.suptitle(suptitle_text)

# Add legend
ax.legend(loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_111.pdf", bbox_inches="tight")
