
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample data
import numpy as np

np.random.seed(0)
weeks = [1, 4, 7, 10, 13, 16, 19, 22, 25, 28]
social_media_engagement = np.array([0.1, 0.3, 0.6, 0.9, 1.2, 1.1, 1.0, 0.8, 0.6, 0.4])
traditional_media_consumption = np.array([1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1])

# Axes Limits and Labels
xlabel_value = "Week"
xlim_values = [0, 30]

ylabel_value = "Engagement/Consumption"
ylim_values = [0, 1.5]
yticks_values = [0, 0.5, 1.0, 1.5]

axvspan1_l, axvspan1_r = 5, 15
axvspan2_l, axvspan2_r = 20, 25

# Labels
label_1 = "Social Media Engagement"
label_2 = "Traditional Media Consumption"

# Annotations
annotation_1 = "Peak\nEngagement"
annotation_2 = "Decline\nStarts"

# Additional Labels
title_value = "Media Consumption Trends Over Time"
suptitle_value = "Comparing Social Media Engagement and Traditional Media Consumption"
legend_labels = [label_1, label_2]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(weeks, social_media_engagement, "b--s", label=label_1)
ax.plot(weeks, traditional_media_consumption, "g-^", label=label_2)

# Highlight specific regions
ax.axvspan(axvspan1_l, axvspan1_r, color="lightcoral", alpha=0.3)
ax.axvspan(axvspan2_l, axvspan2_r, color="lightblue", alpha=0.3)

# Annotations
ax.annotate(
    annotation_1,
    xy=(13, 1.2),
    xytext=(15, 1.3),
    arrowprops=dict(facecolor="orange", shrink=0.05),
)
ax.annotate(
    annotation_2,
    xy=(22, 0.3),
    xytext=(24, 0.3),
    arrowprops=dict(facecolor="purple", shrink=0.05),
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xticks(weeks)
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)
fig.suptitle(suptitle_value)

# Add legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_112.pdf", bbox_inches="tight")
