
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for stock prices
days = np.arange(1, 21)
company_A = np.linspace(150, 180, 20) + np.random.normal(0, 2, 20)
company_B = np.linspace(120, 140, 20) + np.random.normal(0, 1.5, 20)
company_C = np.linspace(90, 110, 20) + np.random.normal(0, 1, 20)
company_D = np.linspace(50, 70, 20) + np.random.normal(0, 0.5, 20)

# Axes Limits and Labels
xlabel_value = "Day"
xlim_values = [0.5, 20.5]
xticks_values = np.arange(1, 21, 1)

ylabel_value = "Stock Price (USD)"
ylim_values = [40, 200]
yticks_values = np.arange(40, 201, 20)

# Labels
label_CompanyA = "Company A"
label_CompanyB = "Company B"
label_CompanyC = "Company C"
label_CompanyD = "Company D"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))
plt.plot(
    days,
    company_A,
    marker="o",
    markersize=6,
    color="#1f77b4",
    linestyle="-",
    linewidth=2,
    label=label_CompanyA,
)
plt.plot(
    days,
    company_B,
    marker="s",
    markersize=6,
    color="#ff7f0e",
    linestyle="--",
    linewidth=2,
    label=label_CompanyB,
)
plt.plot(
    days,
    company_C,
    marker="^",
    markersize=6,
    color="#2ca02c",
    linestyle=":",
    linewidth=2,
    label=label_CompanyC,
)
plt.plot(
    days,
    company_D,
    marker="D",
    markersize=6,
    color="#d62728",
    linestyle="-.",
    linewidth=2,
    label=label_CompanyD,
)

# Set y-axis ticks and limits
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Setting x-axis ticks and limits
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title("Stock Prices Over 20 Days", fontsize=18)

# Adding legend with a different style and position
plt.legend(frameon=True, fontsize=11, loc="upper left")

# Adding gridlines
plt.grid(True, linestyle="-", linewidth=0.5, axis="y", alpha=1)

# Adjusting tick label size
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_113.pdf", bbox_inches="tight")
