
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Sample data for a psychology study on response time (in milliseconds) across different cognitive tasks
sessions = np.arange(1, 21)
control_group = np.linspace(600, 450, 20) + np.random.normal(0, 15, 20)  # Control group
treatment_group_1 = np.linspace(500, 350, 20) + np.random.normal(0, 15, 20)  # Treatment Group 1
treatment_group_2 = np.linspace(550, 400, 20) + np.random.normal(0, 15, 20)  # Treatment Group 2
treatment_group_3 = np.linspace(520, 380, 20) + np.random.normal(0, 15, 20)  # Treatment Group 3

# Axes Limits and Labels
xlabel_value = "Session"
xlim_values = [0.5, 20.5]
xticks_values = np.arange(1, 21, 1)

ylabel_value = "Average Response Time (ms)"
ylim_values = [300, 700]
yticks_values = np.arange(300, 701, 50)

# Labels
label_control = "Control Group"
label_treatment_1 = "Treatment Group 1"
label_treatment_2 = "Treatment Group 2"
label_treatment_3 = "Treatment Group 3"
title="Average Response Time Across Sessions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))
plt.plot(
    sessions,
    control_group,
    marker="o",
    markersize=7,
    color="#1f77b4",  # Blue
    mfc="w",
    mew=1.5,
    label=label_control,
    linewidth=2,
)
plt.plot(
    sessions,
    treatment_group_1,
    marker="s",
    markersize=7,
    color="#ff7f0e",  # Orange
    mfc="w",
    mew=1.5,
    label=label_treatment_1,
    linewidth=2,
)
plt.plot(
    sessions,
    treatment_group_2,
    marker="^",
    markersize=7,
    color="#2ca02c",  # Green
    mfc="w",
    mew=1.5,
    label=label_treatment_2,
    linewidth=2,
)
plt.plot(
    sessions,
    treatment_group_3,
    marker="D",
    markersize=7,
    color="#d62728",  # Red
    mfc="w",
    mew=1.5,
    label=label_treatment_3,
    linewidth=2,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Setting x-axis ticks
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18, pad=15)

# Adding legend with a different style and position
plt.legend(frameon=True, fontsize=12, loc="upper right")

# Adding gridlines
plt.grid(True, linestyle="--", linewidth=0.6, axis="y", alpha=0.7)

# Adjusting tick label size
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_114.pdf", bbox_inches="tight")
