
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# New sample data for energy consumption trends
tasks = np.arange(1, 21)
device_A = np.linspace(100, 50, 20) + np.random.normal(0, 5, 20)
device_B = np.linspace(80, 40, 20) + np.random.normal(0, 4, 20)
device_C = np.linspace(60, 30, 20) + np.random.normal(0, 3, 20)
device_D = np.linspace(40, 20, 20) + np.random.normal(0, 2, 20)

# Axes Limits and Labels
xlabel_value = "Task"
xlim_values = [0.5, 20.5]
xticks_values = np.arange(1, 21, 1)

ylabel_value = "Energy Consumption (kWh)"
ylim_values = [0, 120]
yticks_values = np.arange(0, 121, 10)

# Labels
label_device_A = "Device A"
label_device_B = "Device B"
label_device_C = "Device C"
label_device_D = "Device D"
title="Energy Consumption Over Tasks for Different Devices"
suptitle="Energy Consumption Trends"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))
plt.plot(
    tasks,
    device_A,
    marker="o",
    markersize=8,
    color="#1f77b4",  # Blue
    mfc="w",
    mew=2,
    linestyle="-",
    label=label_device_A,
    linewidth=2,
)
plt.plot(
    tasks,
    device_B,
    marker="s",
    markersize=8,
    color="#ff7f0e",  # Orange
    mfc="w",
    mew=2,
    linestyle="--",
    label=label_device_B,
    linewidth=2,
)
plt.plot(
    tasks,
    device_C,
    marker="^",
    markersize=8,
    color="#2ca02c",  # Green
    mfc="w",
    mew=2,
    linestyle=":",
    label=label_device_C,
    linewidth=2,
)
plt.plot(
    tasks,
    device_D,
    marker="d",
    markersize=8,
    color="#d62728",  # Red
    mfc="w",
    mew=2,
    linestyle="-.",
    label=label_device_D,
    linewidth=2,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Setting x-axis ticks
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)
plt.suptitle(suptitle, fontsize=20)

# Adding legend with a different style and position
plt.legend(frameon=True, fontsize=12, loc="upper right")

# Adding gridlines
plt.grid(True, linestyle="-", linewidth=0.5, axis="y", alpha=0.7)

# Adjusting tick label size
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_115.pdf", bbox_inches="tight")
