
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data: Smartphone Market Share over Time
years = [2018, 2019, 2020, 2021, 2022]
brand_a_share = [30, 32, 35, 37, 40]
brand_b_share = [25, 27, 26, 29, 31]
brand_c_share = [20, 18, 17, 16, 15]

# Extracted variables
brand_a_label = "Brand A"
brand_b_label = "Brand B"
brand_c_label = "Brand C"

ylim_values = [0, 50]
yticks_values = [0, 10, 20, 30, 40, 50]
yticks_labels = ["$0$", "$10$", "$20$", "$30$", "$40$", "$50$"]
xlabel_value = "Year"
ylabel_value = "Market Share (%)"
xlim_values = [2018, 2022]
xticks_fontsize = "12"
yticks_fontsize = "12"
xlabel_fontsize = "14"
ylabel_fontsize = "14"
title_value = "Smartphone Market Share Over Time"
supertitle_value = "Market Trends (2018-2022)"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

legend_location = "upper left"
legend_ncol = 3
legend_bbox_to_anchor = (0, 0.95)
legend_frameon = False

# Plot the data
ax.plot(
    years,
    brand_a_share,
    "o-",
    label=brand_a_label,
    clip_on=False,
    zorder=10,
    color="#1f77b4",  # blue
    linewidth=2.0,
    markersize=8,
    linestyle='--'
)
ax.plot(
    years,
    brand_b_share,
    "s-",
    label=brand_b_label,
    clip_on=False,
    zorder=10,
    color="#ff7f0e",  # orange
    linewidth=2.0,
    markersize=8,
    linestyle='-.'
)
ax.plot(
    years,
    brand_c_share,
    "^-",
    label=brand_c_label,
    clip_on=False,
    zorder=10,
    color="#9467bd",  # purple
    linewidth=2.0,
    markersize=8,
    linestyle=':'
)

plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_labels, fontsize=yticks_fontsize)

# Set x-axis to only display specific ticks and extend x-axis to leave space at right
plt.xticks(years, fontsize=xticks_fontsize)
plt.xlim(xlim_values)
plt.tick_params(axis="both", which="both", color="gray")

# Add legend, labels, title and grid
ax.legend(
    loc=legend_location,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
    frameon=legend_frameon,
)
ax.set_xlabel(xlabel_value, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel_value, fontsize=ylabel_fontsize)
ax.grid(True)
fig.suptitle(supertitle_value, fontsize=16)
ax.set_title(title_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_118.pdf", bbox_inches="tight")
