
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data for plotting
age_groups = np.array([10, 20, 30, 40, 50, 60, 70])
well_being_index = np.array([60, 68, 72, 75, 70, 65, 62])

# Axes Limits and Labels
xlabel_value = "Age Groups"
xlim_values = [0, 80]
xticks_values = np.arange(0, 81, 10)

ylabel_value = "Well-Being Index"
ylim_values = [50, 80]
yticks_values = np.arange(50, 81, 5)

# Title and Labels
chart_title = "Well-Being Index Across Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 5))  # Use subplots to get access to the axis object
ax.plot(age_groups, well_being_index, marker="s", linestyle="--", linewidth=2, color="#76c7c0")

# Set the scale of the y-axis to linear
ax.set_yscale("linear")

# Setting x-axis ticks
ax.set_xticks(xticks_values)
ax.set_xlim(xlim_values)

# Setting y-axis ticks
ax.set_yticks(yticks_values)
ax.set_ylim(ylim_values)

# Adjusting tick label size
plt.xticks(fontsize=11, fontweight="500")
plt.yticks(fontsize=11, fontweight="500")

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  # Remove tick marks and set their color

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(chart_title, fontsize=15, fontweight="bold", pad=20)

# Show grid with lighter color and only major lines
ax.grid(True, which="major", color="lightgrey", linestyle="-", linewidth=0.5)

# Change the axis colors
ax.spines["bottom"].set_color("#d2d2d2")
ax.spines["top"].set_color("#d2d2d2")  # Optional: hide or set color
ax.spines["left"].set_color("#d2d2d2")
ax.spines["right"].set_color("#d2d2d2")  # Optional: hide or set color

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_120.pdf", bbox_inches="tight")
