
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
age_groups = np.array([10, 20, 30, 40, 50, 60, 70])
water_intake = np.array([1.0, 1.5, 2.0, 2.5, 2.0, 1.5, 1.2])

# Axes Limits and Labels
xlabel_value = "Age Groups (years)"
xlim_values = [0, 80]
xticks_values = np.arange(0, 81, 10)

ylabel_value = "Average Daily Water Intake (liters)"
ylim_values = [0, 3]
yticks_values = np.arange(0, 3.1, 0.5)
yticklabels = ["0", "0.5", "1.0", "1.5", "2.0", "2.5", "3.0"]
chart_title = "Average Daily Water Intake by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))  # Increase figure size for better readability
ax.plot(age_groups, water_intake, marker="s", linestyle="--", color="#007acc", markerfacecolor="orange")

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)
ax.set_ylim(ylim_values)  # Set limits to include a small margin

# Remove minor ticks
ax.tick_params(axis="y", which="minor", left=False)

# Setting x-axis ticks
ax.set_xticks(xticks_values)  # Set x-ticks to be every 10 years
ax.set_xlim(xlim_values)  # Set limits to include a small margin

# Adjusting tick label size
plt.xticks(fontsize=12, fontweight="100")
plt.yticks(fontsize=12, fontweight="100")

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  # Remove tick marks and set their color

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(chart_title, fontsize=16, fontweight="bold")

# Show grid with lighter color and only major lines
ax.grid(True, which="major", color="lightgrey", linestyle="-", linewidth=0.5)

# Change the axis colors
ax.spines["bottom"].set_color("#d2d2d2")
ax.spines["top"].set_color("#d2d2d2")  # Optional: hide or set color
ax.spines["left"].set_color("#d2d2d2")
ax.spines["right"].set_color("#d2d2d2")  # Optional: hide or set color

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_121.pdf", bbox_inches="tight")
