
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for philosophy domain
iterations = np.array([0, 250, 500, 750, 1000, 1250, 1500, 1750, 2000])
school_a = np.array([0.2, 0.35, 0.5, 0.6, 0.7, 0.75, 0.8, 0.85, 0.9])
school_a_ft = np.array([0.1, 0.25, 0.4, 0.55, 0.65, 0.7, 0.75, 0.8, 0.85])
school_b = np.array([0.15, 0.3, 0.45, 0.55, 0.65, 0.7, 0.75, 0.8, 0.85])
school_b_ft = np.array([0.05, 0.2, 0.35, 0.5, 0.6, 0.65, 0.7, 0.75, 0.8])

# Axes Limits and Labels
xlabel_value = "Iterations"
ylabel_value = "Interest Level"

# Labels
label_1 = "School A"
label_2 = "School A (Enriched)"
label_3 = "School B"
label_4 = "School B (Enriched)"

# Titles
title_1 = "Interest in School A over Time"
title_2 = "Interest in School B over Time"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to ensure good readability
plt.figure(figsize=(12, 6))

# First subplot
plt.subplot(1, 2, 1)
plt.plot(
    iterations,
    school_a,
    marker="s",
    linestyle="--",
    color="#FF6347",
    label=label_1,
    markerfacecolor="#FF6347",
    linewidth=2,
    markersize=7,
)
plt.plot(
    iterations,
    school_a_ft,
    marker="o",
    linestyle="-",
    color="#4682B4",
    label=label_2,
    markerfacecolor="#4682B4",
    linewidth=2,
    markersize=7,
)
plt.fill_between(iterations, school_a - 0.05, school_a + 0.05, color="#FF6347", alpha=0.2)
plt.fill_between(
    iterations, school_a_ft - 0.03, school_a_ft + 0.03, color="#4682B4", alpha=0.2
)
plt.title(title_1, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.legend(loc="lower right", frameon=True, fontsize=12)

# Second subplot
plt.subplot(1, 2, 2)
plt.plot(
    iterations,
    school_b,
    marker="s",
    linestyle="--",
    color="#32CD32",
    label=label_3,
    markerfacecolor="#32CD32",
    linewidth=2,
    markersize=7,
)
plt.plot(
    iterations,
    school_b_ft,
    marker="o",
    linestyle="-",
    color="#8A2BE2",
    label=label_4,
    markerfacecolor="#8A2BE2",
    linewidth=2,
    markersize=7,
)
plt.fill_between(
    iterations, school_b - 0.05, school_b + 0.05, color="#32CD32", alpha=0.2
)
plt.fill_between(
    iterations, school_b_ft - 0.03, school_b_ft + 0.03, color="#8A2BE2", alpha=0.2
)
plt.title(title_2, fontsize=16)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.legend(loc="lower right", frameon=True, fontsize=12, bbox_to_anchor=(1, 0.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_122.pdf", bbox_inches="tight")
