
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Seed for reproducibility

# Data for plotting
fraction_of_study_time = np.array([0.01, 0.1, 1])
lecture_scores = np.array([50, 70, 85])
self_study_scores = np.array([45, 68, 82])
online_course_scores = np.array([40, 65, 78])

# Axes Limits and Labels
xlabel_value = "Fraction of Study Time (log scale)"
xlim_values = [0.005, 2]

ylabel_value = "Average Test Score (%)"
ylim_values = [35, 90]
yticks_values = np.arange(40, 91, 10)

# Labels
label_Lecture = "Lecture"
label_SelfStudy = "Self-study"
label_OnlineCourse = "Online Course"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(6, 4.5))  # Adjusting figure size

# Plotting the data with new colors and styles
plt.plot(fraction_of_study_time, lecture_scores, 'o-', color='teal', label=label_Lecture, linewidth=2, markersize=8)
plt.plot(fraction_of_study_time, self_study_scores, 's--', color='orange', label=label_SelfStudy, linewidth=2, markersize=8)
plt.plot(fraction_of_study_time, online_course_scores, '^:', color='purple', label=label_OnlineCourse, linewidth=2, markersize=8)

# Configure y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)

# Configure x-axis fontsize and set to log scale
plt.xticks(fontsize=14)
plt.xscale("log")

# Adding labels and title with appropriate fontsize
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Adding grid with customized style
plt.grid(True, which="both", ls="-.", linewidth=0.7)

# Adding legend, adjusting its position and style
plt.legend(loc="lower right", fontsize=12, ncol=3, columnspacing=0.5, edgecolor="black")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjusting layout for better fit
plt.savefig("line_126.pdf", bbox_inches="tight")
