
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation and Labels
# ===================
import numpy as np

np.random.seed(42)

# Define subplot titles
titles = [
    "Mathematics Scores Over Time",
    "Science Scores Over Time",
    "Literature Scores Over Time",
    "Art Scores Over Time",
]

# Generate new datasets for each subplot
data_sets = []
for i in range(4):
    years = np.arange(2010, 2020)
    scores_method_1 = np.random.uniform(60, 90, len(years))
    scores_method_2 = np.random.uniform(65, 85, len(years))
    method_3_mean = np.mean(scores_method_1) * np.ones(len(years))
    method_4_mean = np.mean(scores_method_2) * np.ones(len(years))
    error = np.random.uniform(2, 5, len(years))
    data_sets.append((years, scores_method_1, scores_method_2, method_3_mean, method_4_mean, error))

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Average Score"

# Labels
label_1 = "Method 1"
label_2 = "Method 2"
label_3 = "Method 1 Mean"
label_4 = "Method 2 Mean"
suptitle="Comparison of Teaching Methods in Different Subjects"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(18, 10))

# Loop through each subplot
for i in range(4):
    years, scores_method_1, scores_method_2, method_3_mean, method_4_mean, error = data_sets[i]
    
    plt.subplot(2, 2, i + 1)
    plt.plot(years, scores_method_1, "-o", label=label_1, color="#1f77b4", linewidth=2, markersize=8)
    plt.fill_between(
        years,
        scores_method_1 - error,
        scores_method_1 + error,
        color="#1f77b4",
        alpha=0.2,
    )
    plt.plot(years, scores_method_2, "-s", label=label_2, color="#ff7f0e", linewidth=2, markersize=8)
    plt.fill_between(
        years,
        scores_method_2 - error,
        scores_method_2 + error,
        color="#ff7f0e",
        alpha=0.2,
    )
    plt.plot(years, method_3_mean, "--", label=label_3, color="#1f77b4", linewidth=2)
    plt.plot(years, method_4_mean, "--", label=label_4, color="#ff7f0e", linewidth=2)
    plt.title(titles[i], fontsize=14)
    plt.xlabel(xlabel_value, fontsize=12)
    plt.ylabel(ylabel_value, fontsize=12)
    plt.legend(loc="upper left", fontsize=10)
    plt.grid(True)

# Add supertitle
plt.suptitle(suptitle, fontsize=16)
# Adjust layout
plt.tight_layout(rect=[0, 0, 1, 0.96])

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.savefig("line_128.pdf", bbox_inches="tight")
