
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
likes = [50, 70, 90, 120, 150, 180, 200, 170, 140, 110, 80, 60]
shares = [30, 45, 60, 90, 125, 150, 160, 140, 120, 90, 60, 40]

# Variables for plot configuration
likes_label = "Likes"
shares_label = "Shares"
xlim_values = (0, len(months) - 1)
ylim_values = (20, 220)
xlabel_text = "Months"
ylabel_text = "Engagement Metrics"
xticks_values = np.arange(len(months))
yticks_values = np.arange(20, 221, 20)
xtickslabel_fontsize = 14
ytickslabel_fontsize = 14
title_text = "Monthly Social Media Engagement"
axhline_value = None
axvline_value = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(10, 7))  # Adjusting figure size
plt.plot(
    months,
    likes,
    marker="o",
    linestyle="-",
    linewidth=2.5,
    clip_on=False,
    zorder=10,
    color="#4b8bbe",
    markersize=8,
    label=likes_label,
    mec="black",
    mfc="#4b8bbe",
    mew=1,
)  # Adjusted color and marker size
plt.plot(
    months,
    shares,
    marker="s",
    linestyle="-.",
    linewidth=2.5,
    clip_on=False,
    zorder=10,
    color="#ff7f0e",
    markersize=8,
    label=shares_label,
    mec="black",
    mfc="#ff7f0e",
    mew=1,
)  # Adjusted color, line style, and marker size

# Adding titles and labels with increased font size
plt.yticks(yticks_values, fontsize=ytickslabel_fontsize)
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)
plt.ylim(*ylim_values)
plt.xlim(*xlim_values)
plt.xlabel(xlabel_text, fontsize=xtickslabel_fontsize)
plt.ylabel(ylabel_text, fontsize=ytickslabel_fontsize)
plt.title(title_text, fontsize=18)

# Adding legend
plt.legend(
    markerscale=1,
    fontsize=14,
    loc="best",
    frameon=False,
)

# Changing the background color to #f5f5f5
plt.gca().set_facecolor("#f5f5f5")

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#f5f5f5")
ax.spines["top"].set_color("#f5f5f5")  # Optional: hide or set color
ax.spines["left"].set_color("#f5f5f5")
ax.spines["right"].set_color("#f5f5f5")  # Optional: hide or set color

plt.tick_params(axis="both", which="both", length=0)
# Adding grid
plt.grid(True, color="white")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_131.pdf", bbox_inches="tight")

