
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# Data for plotting
import numpy as np

np.random.seed(0)
years = ["2012", "2013", "2014", "2015", "2016", "2017", "2018", "2019", "2020", "2021"]
city_a_temps = [20, 21, 19, 22, 21, 23, 24, 24.5, 25, 26]
city_b_temps = [15, 15.5, 16, 16.5, 17, 17.5, 18, 18.5, 19, 19.5]

# Variables for plot configuration
city_a_label = "City A"
city_b_label = "City B"
xlim_values = (0, len(years) - 1)
ylim_values = (14, 27)
xlabel_text = "Year"
ylabel_text = "Average Temperature (°C)"
xticks_values = np.arange(len(years))
yticks_values = np.arange(14, 28, 2)
xtickslabel_fontsize = 16
ytickslabel_fontsize = 16
title_text = "Average Temperature Changes Over Years"
axhline_value = None  # No axhline in this chart
axvline_value = None  # No axvline in this chart

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting the lines
plt.figure(figsize=(9, 6))  # Adjusting figure size
plt.plot(
    years,
    city_a_temps,
    marker="o",
    linestyle="--",
    linewidth=3,
    clip_on=False,
    zorder=10,
    color="#ff6347",  # Tomato color
    markersize=10,
    label=city_a_label,
    mec="#ff4500",  # OrangeRed for marker edge color
    mfc="white",
    mew=2,
)
plt.plot(
    years,
    city_b_temps,
    marker="s",
    linestyle="-.",
    linewidth=3,
    clip_on=False,
    zorder=10,
    color="#1e90ff",  # DodgerBlue color
    markersize=10,
    label=city_b_label,
    mec="#4682b4",  # SteelBlue for marker edge color
    mfc="white",
    mew=2,
)

# Adding titles and labels with increased font size
plt.title(title_text, fontsize=20)
plt.yticks(yticks_values, fontsize=ytickslabel_fontsize)
plt.xticks(xticks_values, labels=years, fontsize=xtickslabel_fontsize)
plt.ylim(*ylim_values)
plt.xlim(*xlim_values)
plt.xlabel(xlabel_text, fontsize=xtickslabel_fontsize)
plt.ylabel(ylabel_text, fontsize=ytickslabel_fontsize)

# Adding legend with square markers
plt.legend(
    markerscale=1,
    fontsize=16,
    loc="lower center",
    bbox_to_anchor=(0.5, -0.25),
    ncol=2,
    frameon=False,
)

# Changing the background color to #f5f5f5
plt.gca().set_facecolor("#f5f5f5")

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#f5f5f5")
ax.spines["top"].set_color("#f5f5f5")  # Optional: hide or set color
ax.spines["left"].set_color("#f5f5f5")
ax.spines["right"].set_color("#f5f5f5")  # Optional: hide or set color

plt.tick_params(axis="both", which="both", length=0)
# Adding grid
plt.grid(True, color="white")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_132.pdf", bbox_inches="tight")
