
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Importing numpy
import numpy as np

# Data for plotting - Voter Approval Ratings Over Months
np.random.seed(1)
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct"]
approval_ratings = [55, 52, 50, 48, 47, 45, 49, 53, 51, 50]
approval_change = [
    "+1.5%",
    "-1.0%",
    "-2.0%",
    "-1.5%",
    "-2.0%",
    "-3.0%",
    "+4.0%",
    "+3.5%",
    "-2.0%",
    "-1.0%",
]

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [-1, 10]  # Extra space for better visualization
xticks_values = np.arange(10)
xticks_labels = months

ylabel_value = "Approval Rating (%)"
ylim_values = [40, 60]
yticks_values = np.arange(40, 61, 5)

# Labels
label_1 = "Approval Ratings"
label_2 = "Candidate X (Start): 55%"
label_3 = "Candidate Y (End): 50%"
title="Candidate Approval Ratings Over 10 Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the line
ax.plot(approval_ratings, marker="o", linestyle="-.", color="blue", label=label_1)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=10)
plt.xticks(xticks_values, xticks_labels, fontsize=10)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Annotate the points with approval change values
for i, txt in enumerate(approval_change):
    ax.annotate(
        txt, (i, approval_ratings[i]), textcoords="offset points", xytext=(0, 8), ha="center"
    )

# Horizontal lines for comparison
ax.axhline(y=55, color="green", linestyle="--", label=label_2)
ax.axhline(y=50, color="red", linestyle="--", label=label_3)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title, fontsize=14)

# Set the legend
ax.legend(loc="upper right", fontsize=10)

# Set grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_136.pdf", bbox_inches="tight")
