
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data representing decades from 1950 to 2020
x = [1950, 1960, 1970, 1980, 1990, 2000, 2010, 2020]
y = [
    40.5, 45.2, 50.8, 57.1, 63.4, 71.2, 78.9, 85.3
]
labels = [
    "40.5", "45.2", "50.8", "57.1", "63.4", "71.2", "78.9", "85.3"
]

# Axes Limits and Labels
xlabel_value = "Decade"
xlim_values = [1940, 2030]
xticks_values = [1950, 1960, 1970, 1980, 1990, 2000, 2010, 2020]
xticklabels = [str(year) for year in xticks_values]

ylabel_value = "Development Index (%)"
ylim_values = [35, 90]
yticks_values = np.arange(40, 86, 10)

# Text Labels and Title
title_value = "Socio-Economic Development Index Over Decades"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(6, 3))  # Adjust the size to match the new arrangement
ax.plot(
    x,
    y,
    marker="^",
    color="#2ca02c",
    linestyle="--",
    linewidth=2,
    markersize=6,
    mfc="red",
    mec="white",
)

# Annotate each point with its label
for i, label in enumerate(labels):
    ax.annotate(
        label,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=7,
    )

# Configure x-axis
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)
ax.set_xlim(xlim_values)

# Configure y-axis
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)

# Set labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value, fontsize=12, weight='bold', color="#2ca02c")

# Change the plot background color
ax.set_facecolor("#f4f6f8")

# Show grid
plt.grid(True, which="both", linestyle="--", linewidth=0.5, color="#e5e5e5")

# Change the axis colors
ax.spines["bottom"].set_color("#d3d3d3")
ax.spines["top"].set_color("#d3d3d3")
ax.spines["left"].set_color("#d3d3d3")
ax.spines["right"].set_color("#d3d3d3")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_138.pdf", bbox_inches="tight")
