
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New Tourism Data 
x = [1, 2, 4, 8, 16, 32, 64, 128, 256]
y = [5, 12, 25, 35, 50, 65, 75, 85, 90]
labels = ["5", "12", "25", "35", "50", "65", "75", "85", "90"]

# Axes Limits and Labels
xlabel_value = "Number of Promotional Campaigns"
xlim_values = [1, 256]
xticks_values = [1, 4, 16, 64, 256]
xticklabels = ["$2^{0}$", "$2^{2}$", "$2^{4}$", "$2^{6}$", "$2^{8}$"]

ylabel_value = "Percentage Increase in Tourist Visits (%)"
ylim_values = [0, 100]
yticks_values = np.arange(0, 101, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(5, 2)
)
ax.plot(
    x,
    y,
    marker="^",
    color="#2ca02c",
    linestyle="-",
    linewidth=2,
    markersize=6,
    mfc="#d62728",
    mec="white",
)

# Annotate each point with its label
for i, label in enumerate(labels):
    ax.annotate(
        label,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=7,
    )

# Set x-axis to be logarithmic
ax.set_xscale("log", base=2)  

# Set x-axis labels to be in the format of 2^n
ax.set_xticks(xticks_values)
ax.set_xticklabels(
    xticklabels,
)
ax.set_xlim(xlim_values)  

# Set y-axis ticks
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  

# Set labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# Change the plot background color
ax.set_facecolor("#faf0e6")

# Show grid
plt.grid(True, which="both", linestyle="-", linewidth=1, color="white")

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#f5f5f5")
ax.spines["top"].set_color("#f5f5f5")
ax.spines["left"].set_color("#f5f5f5")
ax.spines["right"].set_color("#f5f5f5")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig("line_139.pdf", bbox_inches="tight")
