
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data for plotting
years = ["2000", "2005", "2010", "2015", "2020", "2025", "2030"]
christianity = [0.6, 0.59, 0.58, 0.57, 0.56, 0.55, 0.54]
islam = [0.2, 0.21, 0.22, 0.23, 0.25, 0.27, 0.29]
hinduism = [0.1, 0.1, 0.11, 0.12, 0.13, 0.14, 0.15]
buddhism = [0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05]
others = [0.05, 0.05, 0.04, 0.03, 0.01, 0.01, 0.01]

# Variables for plot configuration
line_labels = ["Christianity", "Islam", "Hinduism", "Buddhism", "Others"]
xlim_values = (0, len(years) - 1)
ylim_values = (0, 1)
xlabel_value = "Year"
ylabel_value = "Population Proportion"
xticks_values = range(len(years))
yticks_values = np.arange(0, 1.1, 0.2)
xtickslabel_values = years
ytickslabel_values = None
title_value = "Religious Groups Population Proportion Over Time"
axhline_value = None
axvline_value = None

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(10, 7))

plt.plot(
    years,
    christianity,
    "o-",
    clip_on=False,
    zorder=10,
    color="#7d7dff",
    label=line_labels[0],
    linewidth=2,
    markersize=8
)
plt.plot(
    years,
    islam,
    "s-",
    clip_on=False,
    zorder=10,
    color="#ff7f50",
    label=line_labels[1],
    linewidth=2,
    markersize=8
)
plt.plot(
    years,
    hinduism,
    "^-",
    clip_on=False,
    zorder=10,
    color="#98fb98",
    label=line_labels[2],
    linewidth=2,
    markersize=8
)
plt.plot(
    years,
    buddhism,
    "D-",
    clip_on=False,
    zorder=10,
    color="#dda0dd",
    label=line_labels[3],
    linewidth=2,
    markersize=8
)
plt.plot(
    years,
    others,
    "v-",
    clip_on=False,
    zorder=10,
    color="#ffa07a",
    label=line_labels[4],
    linewidth=2,
    markersize=8
)

# Setting x and y ticks
plt.xticks(xticks_values, xtickslabel_values, fontsize=14)
plt.xlim(xlim_values)
plt.yticks(yticks_values, fontsize=14)

# Adding minor y-axis ticks with a step of 0.05
ax = plt.gca()

# Adjust tick parameters
ax.tick_params(axis="both", which="both", length=5, color="gray")  # Move ticks inside
ax.tick_params(
    axis="y", which="minor", length=2
)  # Ensure minor ticks are visible but smaller

# Title and labels
plt.title(title_value, fontsize=16, fontfamily='serif')
plt.xlabel(xlabel_value, fontsize=14, fontfamily='serif')
plt.ylabel(ylabel_value, fontsize=14, fontfamily='serif')

# Enable gridlines for minor ticks
plt.grid(True, color="#b0b0b0", which="major", linestyle="-", linewidth=0.5)

# Legend with serif font family
plt.legend(
    frameon=False, fontsize=12, loc="lower center", bbox_to_anchor=(0.5, -0.3), ncol=3, prop={'family':'serif'}
)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()

plt.savefig("line_147.pdf", bbox_inches="tight")
