
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

# Data for plotting
years = [2000, 2005, 2010, 2015, 2020]
country_a_population = [50, 55, 60, 65, 70]
country_b_population = [40, 42, 46, 50, 55]
country_c_population = [70, 72, 75, 78, 80]

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1998, 2022]
xticks_values = years
xticklabels = [str(year) for year in years]

ylabel_value = "Population (in millions)"
ylim_values = [35, 85]

# Labels
label_countryA = "Country A"
label_countryB = "Country B"
label_countryC = "Country C"

# Title
title_value = "Population Growth Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))
plt.plot(
    years, country_a_population, "o-", label=label_countryA, color="#1f77b4", markersize=6, linewidth=2
)
plt.plot(
    years, country_b_population, "x--", label=label_countryB, color="#ff7f0e", markersize=6, linewidth=2
)
plt.plot(
    years, country_c_population, "s-.", label=label_countryC, color="#2ca02c", markersize=6, linewidth=2
)

# Set x-axis and y-axis limits and ticks
plt.xticks(xticks_values, xticklabels, fontsize=12)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Adding data labels
for i, txt in enumerate(country_a_population):
    plt.annotate(
        txt,
        (years[i], country_a_population[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(country_b_population):
    plt.annotate(
        txt,
        (years[i], country_b_population[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(country_c_population):
    plt.annotate(
        txt,
        (years[i], country_c_population[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )

# Setting the axis labels and title
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16, fontweight='bold')

# Customize the axis colors and line widths
ax = plt.gca()
ax.spines["bottom"].set_color("#7f7f7f")
ax.spines["bottom"].set_linewidth(1.4)
ax.spines["left"].set_color("#7f7f7f")
ax.spines["left"].set_linewidth(1.4)
ax.spines["top"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# Adjust tick parameters to ensure ticks do not extend outside
ax.tick_params(axis="both", which="major", length=6, width=1.2, colors="#7f7f7f")
ax.tick_params(axis="both", which="minor", length=4, width=1, colors="#7f7f7f")

# Adding the legend
plt.legend(loc="upper left", fontsize=12)

# Adding grid
plt.grid(True, which="both", linestyle="--", linewidth=0.5, color="#b0b0b0")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_150.pdf", bbox_inches="tight")
