
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data
x = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
program_a_y = [0.70, 0.72, 0.75, 0.77, 0.78, 0.80, 0.82, 0.84, 0.85, 0.87]
program_b_y = [0.65, 0.67, 0.70, 0.72, 0.73, 0.74, 0.75, 0.77, 0.78, 0.80]
program_c_y = [0.60, 0.62, 0.63, 0.65, 0.67, 0.68, 0.70, 0.72, 0.73, 0.75]

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0, 11]
xticks_values = np.arange(1, 11, 1)

ylabel_value = "Attendance Rate"
ylim_values = [0.55, 0.90]
yticks_values = np.arange(0.60, 0.90, 0.05)

# Labels
label_1 = "Program A"
label_2 = "Program B"
label_3 = "Program C"

title="Monthly Attendance Rate for Religious Study Programs"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(6, 4))

# Line charts
ax.plot(x, program_a_y, marker="o", color="#1f77b4", label=label_1, linestyle='-', linewidth=2)
ax.plot(x, program_b_y, marker="s", color="#ff7f0e", label=label_2, linestyle='--', linewidth=2)
ax.plot(x, program_c_y, marker="^", color="#2ca02c", label=label_3, linestyle='-.', linewidth=2)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=12)
plt.xticks(xticks_values, fontsize=12)
plt.xlim(xlim_values)
plt.ylim([0.55, 0.90])

# Legend
ax.legend(loc="lower right")

# Labels
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# Title
plt.title(title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_152.pdf", bbox_inches="tight")
