
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
x = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
single_genre_y = [150, 160, 170, 180, 190, 200, 210, 220, 230, 240, 250]
multiple_genres_y = [130, 140, 160, 180, 200, 210, 220, 225, 230, 235, 240]
novice_reader_wpm = 100

# Axes Limits and Labels
xlabel_value = "Number of books read per year"
xlim_values = [-1, 11]
xticks_values = np.arange(0, 12, 1)

ylabel_value = "Average reading speed (WPM)"
ylim_values = [90, 260]
yticks_values = np.arange(100, 260, 20)

# Labels
label_1 = "Single Genre"
label_2 = "Multiple Genres"
label_3 = "Novice Reader WPM"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 5))

# Line charts
ax.plot(x, single_genre_y, marker="o", color="#8B4513", label=label_1, linestyle='-', linewidth=2)
ax.plot(x, multiple_genres_y, marker="^", color="#A52A2A", label=label_2, linestyle='--', linewidth=2)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=12)
plt.xticks(xticks_values, fontsize=12)
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Horizontal dashed line
ax.axhline(y=novice_reader_wpm, color="#556B2F", linestyle="-.", label=label_3, linewidth=2)

# Grid
ax.grid(True, linestyle='--', linewidth=0.5, color='gray', alpha=0.7)

# Legend
ax.legend(loc="upper left")

# Labels
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_154.pdf", bbox_inches="tight")
