
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
months = range(1, 13)
sales_growth = [10, 15, 25, 35, 50, 65, 80, 95, 110, 125, 140, 160]
campaign_growth = [10] * 2 + [12, 15, 20, 22, 30, 35] + [35] * 4

# Axes Limits and Labels
xlabel_value = "Month"
xlim_values = [0, 13]
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Growth (%)"
ylim_values = [0, 170]

# Title
chart_title = "Yearly Sales Growth Comparison"

# Labels
label_1 = "Monthly Sales Growth"
label_2 = "Campaign Impact"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(6, 4))
plt.plot(months, sales_growth, marker="o", linestyle="-", label=label_1, color="#1f77b4", linewidth=2, markersize=6)
plt.plot(months, campaign_growth, marker="s", linestyle="--", label=label_2, color="#ff7f0e", linewidth=2, markersize=6)

# Adding title and legend
plt.title(chart_title)
plt.legend()

# Labeling axes
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xlim(xlim_values)
plt.xticks(xticks_values)
plt.ylim(ylim_values)

# Adding grid lines for better readability
plt.grid(True, which='both', linestyle='--', linewidth=0.5)

# Reduce the top and right spines
plt.gca().spines['top'].set_visible(False)
plt.gca().spines['right'].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_155.pdf", bbox_inches="tight")
