
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
years = list(range(2000, 2011))
religious_adherence = [
    0.75,
    0.76,
    0.74,
    0.73,
    0.72,
    0.71,
    0.70,
    0.69,
    0.68,
    0.67,
    0.66,
]
religious_doubt = [
    0.20,
    0.21,
    0.22,
    0.23,
    0.24,
    0.25,
    0.26,
    0.27,
    0.28,
    0.29,
    0.30,
]

# Extracted variables
adherence_label = "Religious Adherence"
doubt_label = "Religious Doubt"
xlim_values = [2000, 2010]
ylim_values = [0.15, 0.80]
xlabel_value = "Year"
ylabel_value = "Proportion"
xticks_values = years
yticks_values = np.arange(0.15, 0.85, 0.05)
xtickslabel_values = [str(i) for i in years]
ytickslabel_values = [str(i) for i in yticks_values]
title_value = "Trends in Religion over Time"
legend_location = "upper right"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1
legend_frameon = True

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(8, 5)
)

# Plot lines
ax.plot(
    years,
    religious_adherence,
    marker="o",
    linestyle="--",
    color="#2E8B57",  # Sea green color
    label=adherence_label,
    markersize=7,
    linewidth=2,
    mec="white",
)
ax.plot(
    years,
    religious_doubt,
    marker="s",
    linestyle=":",
    color="#8B0000",  # Dark red color
    label=doubt_label,
    markersize=7,
    linewidth=2,
    mec="white",
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=10)
plt.xticks(xticks_values, fontsize=10)
plt.ylim(ylim_values)
plt.xlim(xlim_values)

# Title and labels
ax.set_title(title_value, fontsize=15)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.tick_params(axis="both", which="both", length=5)

# Legend
ax.legend(
    loc=legend_location,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
    fontsize=10
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("line_158.pdf", bbox_inches="tight")
