
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
years = [2000, 2004, 2008, 2012, 2016, 2020]
voter_turnout_democrat = [
    50.0,
    51.2,
    53.1,
    52.4,
    54.0,
    55.3,
]
voter_turnout_republican = [
    48.5,
    49.0,
    48.9,
    49.5,
    49.2,
    50.1,
]

# Extracted variables
democrat_label = "Voter Turnout (Democrat)"
republican_label = "Voter Turnout (Republican)"
xlim_values = [2000, 2020]
ylim_values = [47, 57]
xlabel_value = "Election Year"
ylabel_value = "Voter Turnout (%)"
xticks_values = years
yticks_values = np.arange(47, 58, 1)
xtickslabel_values = [str(year) for year in years]
ytickslabel_values = [f'{i}%' for i in yticks_values]
title_value = "Voter Turnout in US Presidential Elections"
legend_location = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_ncol = 2
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(8, 6)
)  # Adjusted size for better readability

# Plot lines
ax.plot(
    years,
    voter_turnout_democrat,
    marker="o",
    linestyle='-',
    clip_on=False,
    zorder=10,
    color="#377eb8",  # Blue color
    label=democrat_label,
    markersize=8,
    mec="white",
)
ax.plot(
    years,
    voter_turnout_republican,
    marker="s",
    linestyle='--',
    clip_on=False,
    zorder=10,
    color="#e41a1c",  # Red color
    label=republican_label,
    markersize=8,
    mec="white",
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, ytickslabel_values, fontsize=10)
plt.xticks(xticks_values, xtickslabel_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xlim(xlim_values)

# Title and labels
ax.set_title(title_value, fontsize=14)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.tick_params(axis="both", which="both", length=0)

# Legend
ax.legend(
    loc=legend_location,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("line_160.pdf", bbox_inches="tight")
