
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New Data: Approval Ratings of Different Political Parties Over Several Years
years = np.array([2010, 2012, 2014, 2016, 2018])
party_A_ratings = [0.45, 0.5, 0.55, 0.53, 0.6]
party_B_ratings = [0.4, 0.42, 0.38, 0.4, 0.45]
party_C_ratings = [0.3, 0.35, 0.33, 0.37, 0.4]
party_D_ratings = [0.2, 0.25, 0.27, 0.3, 0.35]

# Error values
party_A_error = np.random.uniform(0.01, 0.02, len(years))
party_B_error = np.random.uniform(0.01, 0.02, len(years))
party_C_error = np.random.uniform(0.01, 0.02, len(years))
party_D_error = np.random.uniform(0.01, 0.02, len(years))

# Axes Limits and Labels
xlabel_value = "Years"

ylabel_value = "Approval Ratings"
ylim_values = [0.15, 0.65]
yticks_values = np.arange(0.1, 0.7, 0.1)

# Labels
label_A = "Party A"
label_B = "Party B"
label_C = "Party C"
label_D = "Party D"

title="Approval Ratings of Political Parties Over the Years"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size for better clarity
plt.errorbar(
    years,
    party_A_ratings,
    yerr=party_A_error,
    fmt="-o",
    label=label_A,
    color="#1f77b4",  # Blue
    linestyle="dashdot",
    linewidth=2,
    markersize=8
)
plt.errorbar(
    years,
    party_B_ratings,
    yerr=party_B_error,
    fmt="-s",
    label=label_B,
    color="#ff7f0e",  # Orange
    linestyle="dotted",
    linewidth=2,
    markersize=8
)
plt.errorbar(
    years,
    party_C_ratings,
    yerr=party_C_error,
    fmt="-^",
    label=label_C,
    color="#2ca02c",  # Green
    linestyle="dashed",
    linewidth=2,
    markersize=8
)
plt.errorbar(
    years,
    party_D_ratings,
    yerr=party_D_error,
    fmt="-d",
    label=label_D,
    color="#d62728",  # Red
    linestyle="solid",
    linewidth=2,
    markersize=8
)

# Adding labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(years)
plt.ylim(ylim_values)
plt.yticks(yticks_values)
plt.title(title)

# Adding legend, lower right corner
plt.legend(loc="lower right")

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(
    True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5
)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("line_162.pdf", bbox_inches="tight")
