
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data assumption: Signal-to-Noise Ratio (SNR) improvements over different frequencies
frequencies = np.arange(100, 500, 100)
method_a_accuracy = [0.85, 0.9, 0.87, 0.8]
method_b_accuracy = [0.8, 0.82, 0.88, 0.9]
method_c_accuracy = [0.78, 0.85, 0.83, 0.88]
method_d_accuracy = [0.75, 0.78, 0.85, 0.87]

# Plausible error values
method_a_error = np.random.uniform(0.02, 0.04, len(frequencies))
method_b_error = np.random.uniform(0.03, 0.05, len(frequencies))
method_c_error = np.random.uniform(0.01, 0.03, len(frequencies))
method_d_error = np.random.uniform(0.02, 0.04, len(frequencies))

# Axes Limits and Labels
xlabel_value = "Frequency (MHz)"
ylabel_value = "SNR Improvement (dB)"
ylim_values = [0.7, 1.0]
yticks_values = np.arange(0.7, 1.05, 0.05)

# Labels
label_1 = "Method A"
label_2 = "Method B"
label_3 = "Method C"
label_4 = "Method D"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 7))
plt.errorbar(
    frequencies,
    method_a_accuracy,
    yerr=method_a_error,
    fmt="-o",
    label=label_1,
    color="darkblue",
    linestyle="solid",
    linewidth=2,
    markersize=8,
)
plt.errorbar(
    frequencies,
    method_b_accuracy,
    yerr=method_b_error,
    fmt="-s",
    label=label_2,
    color="darkgreen",
    linestyle="solid",
    linewidth=2,
    markersize=8,
)
plt.errorbar(
    frequencies,
    method_c_accuracy,
    yerr=method_c_error,
    fmt="-^",
    label=label_3,
    color="darkorange",
    linestyle="solid",
    linewidth=2,
    markersize=8,
)
plt.errorbar(
    frequencies,
    method_d_accuracy,
    yerr=method_d_error,
    fmt="-d",
    label=label_4,
    color="darkred",
    linestyle="solid",
    linewidth=2,
    markersize=8,
)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.xticks(frequencies)
plt.ylim(ylim_values)
plt.yticks(yticks_values)

# Adding legend, lower left corner
plt.legend(loc="lower right", fontsize=12)

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_163.pdf", bbox_inches="tight")
